IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[UFD_RET_EST_TOP_SHOW_FP_FUNC]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
	DROP FUNCTION [UFD_RET_EST_TOP_SHOW_FP_FUNC]
GO  
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[UFD_RET_EST_TOP_SHOW]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
	DROP FUNCTION [UFD_RET_EST_TOP_SHOW]
GO 
--SELECT * FROM dbo.UFD_RET_EST_TOP_SHOW_FP_FUNC(1,1,1,123)
CREATE FUNCTION [UFD_RET_EST_TOP_SHOW_FP_FUNC] (@CD_EMP INT=1,@CD_TOP_SHOW INT, @CD_FILIAL INT,@CD_FUN INT)

RETURNS @RS_RETORNO TABLE (CodFilial		INT,
							CodVend			INT,
							Tipo			INT,
							PercParc		MONEY) 
 			
AS
BEGIN
 
DECLARE @VLR_VD_FUNC MONEY,
		@VLR_VD_LJ MONEY,
		@DT_INI DATETIME,
		@DT_FIM DATETIME,
		@PERC_VEND MONEY,
		@TIPO INT;

SELECT 
	@DT_INI=DATEADD(DAY,-120,CASE WHEN CONVERT(DATE,GETDATE()) < DT_INI_TOP_SHOW THEN CONVERT(DATE,GETDATE()) 
								ELSE  DT_INI_TOP_SHOW END),
	@DT_FIM=DATEADD(DAY,-1,CASE WHEN CONVERT(DATE,GETDATE()) < DT_INI_TOP_SHOW THEN CONVERT(DATE,GETDATE()) 
								ELSE  DT_INI_TOP_SHOW END)
FROM 
	EST_TOP_SHOW
WHERE
	CD_EMP=@CD_EMP 
	AND CD_TOP_SHOW =@CD_TOP_SHOW; 

/************************************************************************************************/
-- 
/************************************************************************************************/	
	  
	SET @VLR_VD_LJ =ISNULL((SELECT SUM(I.TOT_IT)
									FROM
										V_PDV_VD_IT I		
									WHERE
										I.CD_EMP = @CD_EMP
										AND I.CD_FILIAL =@CD_FILIAL
										AND I.DT_VD BETWEEN @DT_INI AND @DT_FIM),0);
	  
	SET @VLR_VD_FUNC =ISNULL( (SELECT SUM(I.TOT_IT) 
								FROM
									V_PDV_VD_IT I 
								WHERE
									I.CD_EMP = @CD_EMP
									AND I.CD_FILIAL =@CD_FILIAL
									AND I.CD_VEND	=@CD_FUN
									AND I.DT_VD BETWEEN @DT_INI AND @DT_FIM),0);

	if @VLR_VD_LJ >0 
	begin
		SET @PERC_VEND = (@VLR_VD_FUNC/@VLR_VD_LJ)*100.000;
		if @PERC_VEND =0
			set @VLR_VD_FUNC=0
	end
	SET @TIPO =0;
	IF ISNULL(@VLR_VD_FUNC,0) =0 
	BEGIN
		--Atribui a venda do melhor vendedor
		SET @VLR_VD_FUNC =ISNULL((SELECT TOP 1 SUM(I.TOT_IT) VLR 
								FROM
									V_PDV_VD_IT I 
								WHERE
									I.CD_EMP = @CD_EMP
									AND I.CD_FILIAL =@CD_FILIAL
									AND I.DT_VD BETWEEN @DT_INI AND @DT_FIM
								GROUP BY I.CD_VEND
								ORDER BY VLR DESC),0);
	
		SET @TIPO =1;
	END

	SET @PERC_VEND = 0;

	if @VLR_VD_LJ >0 
	begin
		SET @PERC_VEND = (@VLR_VD_FUNC/@VLR_VD_LJ)*100.000;
	end

	INSERT INTO @RS_RETORNO
	SELECT 
		@CD_FILIAL,
		@CD_FUN,
		@TIPO,
		@PERC_VEND

	RETURN;
END